/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.item.ifo;

import com.technicalitiesmc.lib.item.ifo.IFOStorage;
import com.technicalitiesmc.lib.item.ifo.ItemFunctionalOverride;
import com.technicalitiesmc.lib.network.TKLibNetworkHandler;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class IFOManager {
    private static final Capability<IFOStorage> IFO_STORAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFOStorage>(){});

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(IFOManager::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(IFOManager::onUseItemOnBlock);
    }

    @Nullable
    private static IFOStorage getStorage(Player player) {
        if (player instanceof FakePlayer) {
            return null;
        }
        return (IFOStorage)player.getCapability(IFO_STORAGE_CAPABILITY).orElse(null);
    }

    public static void enable(Player player, ItemFunctionalOverride override) {
        IFOStorage storage = IFOManager.getStorage(player);
        if (storage == null) {
            return;
        }
        storage.setActiveOverride(override);
        if (!player.m_183503_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TKLibNetworkHandler.sendClientboundEnableIFO(serverPlayer, override);
        }
    }

    public static void disable(Player player) {
        IFOStorage storage = IFOManager.getStorage(player);
        if (storage == null) {
            return;
        }
        storage.setActiveOverride(null);
        if (!player.m_183503_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TKLibNetworkHandler.sendClientboundDisableIFO(serverPlayer);
        }
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        IFOStorage storage = IFOManager.getStorage(player);
        if (storage == null || storage.getActiveOverride() == null) {
            return;
        }
        ItemFunctionalOverride override = storage.getActiveOverride();
        if (player.m_183503_().m_5776_()) {
            if (!override.isValid(player.m_183503_(), player)) {
                IFOManager.disable(player);
            }
        } else {
            Component tip = override.getTip(player.m_183503_(), player);
            if (tip != null) {
                player.m_5661_(tip, true);
            }
        }
    }

    private static void onUseItemOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        IFOStorage storage = IFOManager.getStorage(player);
        if (storage == null || storage.getActiveOverride() == null) {
            return;
        }
        ItemFunctionalOverride override = storage.getActiveOverride();
        InteractionResult result = override.use(player.m_183503_(), player, (HitResult)event.getHitVec());
        if (!(player.m_183503_().m_5776_() || result != InteractionResult.SUCCESS && result != InteractionResult.FAIL)) {
            IFOManager.disable(player);
        }
        if (result.m_19077_()) {
            player.m_6674_(InteractionHand.MAIN_HAND);
        }
        event.setCanceled(true);
        event.setCancellationResult(result == InteractionResult.FAIL ? InteractionResult.FAIL : InteractionResult.m_19078_((boolean)player.m_183503_().m_5776_()));
    }
}

